<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:cif="cif" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.1">
<xsl:param select="cif:xslShowHelp" name="xslShowHelp"/>
<xsl:param select="cif:xslRootDirectory" name="xslRootDirectory"/>
    <!-- Least Squares Report -->
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis opakování chyby metody nejmenších čtverců</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <xsl:for-each select="AdjustmentNet">
                                <center>
                                    <!-- Report Title -->
                                    <h2 lang="en">Výpis opakování chyby metody nejmenších čtverců</h2>
                                    <p lang="en">
                                        Datum výpisu:&#xa0; <xsl:value-of select="cif:date()"/><br/>
                                        Čas:&#xa0; <xsl:value-of select="cif:time()"/>
                                    </p>
                                </center>
                                <p lang="en" style="text-align:center;font-size:80%">
                                    <strong>Aktivní geografický systém:&#xa0;</strong>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemName"/>
                                    &#xa0; <xsl:value-of select="//@coordinateSystemDescription"/>
                                    <xsl:if test="//@linearUnits = 'I'">, stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'F'">, Survey stopy</xsl:if>
                                    <xsl:if test="//@linearUnits = 'M'">, metry</xsl:if>
                                </p>
                                <hr/>
                                <!-- Observation Data -->
                                <center>
                                    <h4>Nastavení</h4>
                                </center>
                                <hr size="1px"/>
                                <xsl:for-each select="GenFileReport">
                                    <xsl:for-each select="GenFileSetupList">
                                        <tr style="line-height:50%">
                                            <td>&#xa0;</td>
                                        </tr>
                                        <table class="margin" cellpadding="1" cellspacing="1" width="25%">
                                            <tbody>
                                                <tr>
                                                    <th align="left" nowrap="nowrap">Nastavení zpracování #&#xa0;</th>
                                                    <td align="left" nowrap="nowrap">
                                                        <xsl:value-of select="@setupNumber"/>
                                                    </td>
                                                    <th align="left" nowrap="nowrap">ve stanici:&#xa0;</th>
                                                    <td align="left" nowrap="nowrap">
                                                        <xsl:value-of select="@stationName"/>
                                                    </td>
                                                </tr>
                                                <tr style="line-height:50%">
                                                    <td>&#xa0;</td>
                                                </tr>
                                                <tr>
                                                    <th align="left" nowrap="nowrap">Směrově kolimační sekundy:&#xa0;</th>
                                                    <td align="left" nowrap="nowrap">
                                                        <xsl:choose>
                                                            <xsl:when test="@horizontalCollimationSeconds='*******'">
                                                                <xsl:value-of select="@horizontalCollimationSeconds"/>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:value-of select="cif:distanceFormat(number(@horizontalCollimationSeconds))"/>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                    <th align="left" nowrap="nowrap"> Výškově kolimační sekundy:&#xa0;</th>
                                                    <td align="left" nowrap="nowrap">
                                                        <xsl:choose>
                                                            <xsl:when test="@verticalCollimationSeconds='*******'">
                                                                <xsl:value-of select="@verticalCollimationSeconds"/>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <xsl:value-of select="cif:distanceFormat(number(@verticalCollimationSeconds))"/>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </td>
                                                </tr>

                                                <xsl:for-each select="MultiPoint">
                                                    <xsl:for-each select="MultiPointList">
                                                        <table class="margin" cellpadding="1" cellspacing="1" width="40%">
                                                            <tbody>
                                                                <xsl:choose>
                                                                    <xsl:when test="@isAsterisk='True'">
                                                                        <tr style="color:FF0000">
                                                                            <th align="left" nowrap="nowrap">Chyba opakování na více cílení na stanici:&#xa0;</th>
                                                                            <td align="left" nowrap="nowrap">
                                                                                <xsl:value-of select="@multiPointStationName"/>
                                                                            </td>
                                                                            <th align="left" nowrap="nowrap">je:&#xa0;</th>
                                                                            <td align="right" nowrap="nowrap">
                                                                                <xsl:choose>
                                                                                    <xsl:when test="@multiPointError='*******'">
                                                                                        <xsl:value-of select="@multiPointError"/>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <xsl:value-of select="cif:distanceFormat(number(@multiPointError))"/>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </td>
                                                                            <td align="left">*</td>
                                                                        </tr>
                                                                    </xsl:when>
                                                                    <xsl:otherwise>
                                                                        <tr>
                                                                            <th align="left" nowrap="nowrap">Chyba opakování na více cílení na stanici:&#xa0;</th>
                                                                            <td align="left" nowrap="nowrap">
                                                                                <xsl:value-of select="@multiPointStationName"/>
                                                                            </td>
                                                                            <th align="left" nowrap="nowrap">je:&#xa0;</th>
                                                                            <td align="right" nowrap="nowrap">
                                                                                <xsl:choose>
                                                                                    <xsl:when test="@multiPointError='*******'">
                                                                                        <xsl:value-of select="@multiPointError"/>
                                                                                    </xsl:when>
                                                                                    <xsl:otherwise>
                                                                                        <xsl:value-of select="cif:distanceFormat(number(@multiPointError))"/>
                                                                                    </xsl:otherwise>
                                                                                </xsl:choose>
                                                                            </td>
                                                                        </tr>
                                                                    </xsl:otherwise>
                                                                </xsl:choose>
                                                            </tbody>
                                                        </table>
                                                    </xsl:for-each>
                                                </xsl:for-each>
                                            </tbody>
                                        </table>
                                        <xsl:for-each select="DistanceStandardDeviation">
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">OPAKOVÁNÍ STANDARDNÍ CHYBY&#xa0;</th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                                                <colgroup span="9">
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                    <col width="10%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">
                                                            Pozorovaná<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Std. odch.
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            Směr. rozdíl<br/>SD (střední)
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Max. rozpětí
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Std. odch.
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            Výšk. rozdíl<br/>SD (střední)
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Max. rozpětí
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            Compare<br/>Směr. rozdíl
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Výšk. rozdíl
                                                        </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <tbody>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="80%">
                                                    <xsl:for-each select="DistanceStandardDeviationList">
                                                        <xsl:choose>
                                                            <xsl:when test="@isAsterisk='True' or @isAsteriskElv='True' or @isAsteriskHD='True' or @isAsteriskED='True'">
                                                                <tr style="color:FF0000">
                                                                    <td align="left" nowrap="nowrap">
                                                                        <xsl:value-of select="@distanceStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceStandardDeviation='*******'">
                                                                                <xsl:value-of select="@distanceStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@distanceStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceMaximumSpread='*******'">
                                                                                <xsl:value-of select="@distanceMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationStandardDeviation='*******'">
                                                                                <xsl:value-of select="@elevationStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@elevationStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationMaximumSpread='*******'">
                                                                                <xsl:value-of select="@elevationMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@compareHorizontalDistance='*******'">
                                                                                <xsl:value-of select="@compareHorizontalDistance"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@compareHorizontalDistance))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@compareElevationDifference='*******'">
                                                                                <xsl:value-of select="@compareElevationDifference"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@compareElevationDifference))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="left">*</td>
                                                                </tr>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <tr>
                                                                    <td align="left" nowrap="nowrap">
                                                                        <xsl:value-of select="@distanceStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceStandardDeviation='*******'">
                                                                                <xsl:value-of select="@distanceStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@distanceStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@distanceMaximumSpread='*******'">
                                                                                <xsl:value-of select="@distanceMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@distanceMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationStandardDeviation='*******'">
                                                                                <xsl:value-of select="@elevationStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@elevationStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@elevationMaximumSpread='*******'">
                                                                                <xsl:value-of select="@elevationMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@elevationMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@compareHorizontalDistance='*******'">
                                                                                <xsl:value-of select="@compareHorizontalDistance"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@compareHorizontalDistance))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@compareElevationDifference='*******'">
                                                                                <xsl:value-of select="@compareElevationDifference"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@compareElevationDifference))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                </tr>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </xsl:for-each>
                                                </table>
                                            </tbody>
                                        </xsl:for-each>
                                        <xsl:for-each select="AngleStandardDeviation">
                                            <tr style="line-height:50%">
                                                <td>&#xa0;</td>
                                            </tr>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="50%">
                                                <tbody>
                                                    <tr>
                                                        <th align="left" nowrap="nowrap">OPAKOVÁNÍ STANDARDNÍCH BYCH PRO ÚHLY&#xa0;</th>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                <colgroup span="5">
                                                    <col width="15%"/>
                                                    <col width="15%"/>
                                                    <col width="15%"/>
                                                    <col width="15%"/>
                                                    <col width="15%"/>
                                                </colgroup>
                                                <thead style="display:table-header-group">
                                                    <tr>
                                                        <th class="underline" lang="en" align="left">
                                                            Zpětná<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="left">
                                                            Dopředná<br/>stanice
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Std. odch.</th>
                                                        <th class="underline" lang="en" align="right">
                                                            Std. odch.<br/>(střední)
                                                        </th>
                                                        <th class="underline" lang="en" align="right">
                                                            <br/>Max. rozpětí
                                                        </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <tbody>
                                                <table class="margin" cellpadding="1" cellspacing="1" width="60%">
                                                    <xsl:for-each select="AngleStandardDeviationList">
                                                        <xsl:choose>
                                                            <xsl:when test="@isAsterisk='True'">
                                                                <tr style="color:FF0000">
                                                                    <td align="left" nowrap="nowrap">
                                                                        <xsl:value-of select="@backSightStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:value-of select="@foreSightStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleStandardDeviation='*******'">
                                                                                <xsl:value-of select="@angleStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@angleStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleMaximumSpread='*******'">
                                                                                <xsl:value-of select="@angleMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="left">*</td>
                                                                </tr>
                                                            </xsl:when>
                                                            <xsl:otherwise>
                                                                <tr>
                                                                    <td align="left" nowrap="nowrap">
                                                                        <xsl:value-of select="@backSightStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:value-of select="@foreSightStationName"/>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleStandardDeviation='*******'">
                                                                                <xsl:value-of select="@angleStandardDeviation"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviation))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleStandardDeviationMean='*******'">
                                                                                <xsl:value-of select="@angleStandardDeviationMean"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleStandardDeviationMean))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                    <td align="right" nowrap="nowrap">
                                                                        <xsl:choose>
                                                                            <xsl:when test="@angleMaximumSpread='*******'">
                                                                                <xsl:value-of select="@angleMaximumSpread"/>
                                                                            </xsl:when>
                                                                            <xsl:otherwise>
                                                                                <xsl:value-of select="cif:distanceFormat(number(@angleMaximumSpread))"/>
                                                                            </xsl:otherwise>
                                                                        </xsl:choose>
                                                                    </td>
                                                                </tr>
                                                            </xsl:otherwise>
                                                        </xsl:choose>
                                                    </xsl:for-each>
                                                </table>
                                            </tbody>
                                        </xsl:for-each>
                                    </xsl:for-each>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
       </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
            <h4 lang="en">Poznámky</h4>
            <p class="normal1" lang="en">
             Pro tento výpis potřebujete nejméně jeden polní zápisník v Průzkumníku projektu (Zaměření), který obsahuje síť měření s provedeným vyrovnáním. </p>

<p class="normal1">  V Průzkumníku projektu se ujistěte, že vpravo od Vyrovnání svítí zelená značka (ukazuje kompletní provedení). Pravým kliknutím na Vyrovnání vyberte Výsledky vyrovnání pro odpovídající výpis. </p>
            <p class="normal1">Jakmile je otevřený Průzkumník výpisů, zvolte správný formulář, který umí číst vygenerovaná data pro výpis.</p>
            <p class="small" lang="en">
                <em>&#xa9; 2012 Bentley Systems, Inc</em>
            </p>
        </div>
    </xsl:template>
    </xsl:stylesheet>
